package parser;

/**
 * Factory for S grammar non-terminal objects.
 */
public class SFact extends ATVFactory {
    /**
     * Factory for T grammar non-terminals.
     */
    private TFact _tFact;

    /**
     * Factory for V grammar non-terminals.
     */
    private VFact _vFact;

    /**
     * Factory for P grammar terminals.
     */
    private PFact _pFact;

    /**
     * Constructor for the E1 factory,
     *
     * @param tkz   tokenizer to use
     * @param tFact factory for T non-terminals
     * @param vFact factory for V non-terminals
     * @param pFact factory for P non-terminals
     */
    public SFact(ITokenizer tkz, TFact tFact, VFact vFact, PFact pFact) {
        super(tkz);
        _tFact = tFact;
        _vFact = vFact;
        _pFact = pFact;

    }

    /**
     * Make a token visitor to parse an E1 non-terminal.
     *
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        return _tFact.makeChainedVisitor(_vFact.makeChainedVisitor(_pFact.makeVisitor()));
    }

    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     *
     * @param successor visitor to serve as successor in the chain
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        return _tFact.makeChainedVisitor(_vFact.makeChainedVisitor(_pFact.makeChainedVisitor(successor)));
    }
}

